from django.db import models
from django.contrib.auth.models import User


class Quiz(models.Model):
    title = models.CharField(max_length=128, unique=True)
    info = models.CharField(max_length=255, blank=True)

    def __str__(self):
        return self.title


class Team(models.Model):
    quiz = models.ForeignKey(Quiz, on_delete=models.CASCADE, related_name="teams")
    name = models.CharField(max_length=64)
    capacity = models.PositiveIntegerField(default=2)

    def __str__(self):
        return f"{self.name} @ {self.quiz.title}"


class Membership(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE, related_name="memberships")
    team = models.ForeignKey(Team, on_delete=models.CASCADE, related_name="members")


    def __str__(self):
        return f"{self.user.username} → {self.team.name}"